function createFit(IPTG_range_log10,LacZ_output_log10)
%CREATEFIT Create plot of data sets and fits
%   CREATEFIT(IPTG_RANGE_LOG10,LACZ_OUTPUT_LOG10)
%   Creates a plot, similar to the plot in the main Curve Fitting Tool,
%   using the data that you provide as input.  You can
%   use this function with the same data you used with CFTOOL
%   or with different data.  You may want to edit the function to
%   customize the code and this help message.
%
%   Number of data sets:  1
%   Number of fits:  2

% Data from data set "LacZ_output_log10 vs. IPTG_range_log10":
%     X = IPTG_range_log10:
%     Y = LacZ_output_log10:
%     Unweighted

% Auto-generated by MATLAB on 28-Mar-2011 14:39:46

% Set up figure to receive data sets and fits
f_ = clf;
figure(f_);
set(f_,'Units','Pixels','Position',[658 269 688 485]);
% Line handles and text for the legend.
legh_ = [];
legt_ = {};
% Limits of the x-axis.
xlim_ = [Inf -Inf];
% Axes for the plot.
ax_ = axes;
set(ax_,'Units','normalized','OuterPosition',[0 0 1 1]);
set(ax_,'Box','on');
axes(ax_);
hold on;

% --- Plot data that was originally in data set "LacZ_output_log10 vs. IPTG_range_log10"
IPTG_range_log10 = IPTG_range_log10(:);
LacZ_output_log10 = LacZ_output_log10(:);
h_ = line(IPTG_range_log10,LacZ_output_log10,'Parent',ax_,'Color',[0.333333 0.666667 0],...
    'LineStyle','none', 'LineWidth',1,...
    'Marker','.', 'MarkerSize',12);
xlim_(1) = min(xlim_(1),min(IPTG_range_log10));
xlim_(2) = max(xlim_(2),max(IPTG_range_log10));
legh_(end+1) = h_;
legt_{end+1} = 'LacZ_output_log10 vs. IPTG_range_log10';

% Nudge axis limits beyond data limits
if all(isfinite(xlim_))
    xlim_ = xlim_ + [-1 1] * 0.01 * diff(xlim_);
    set(ax_,'XLim',xlim_)
else
    set(ax_, 'XLim',[-3.04, 1.04]);
end

% --- Create fit "fit 5"
fo_ = fitoptions('method','NonlinearLeastSquares','Lower',[2 -2  4],'Upper',[3 -1  5]);
ok_ = isfinite(IPTG_range_log10) & isfinite(LacZ_output_log10);
if ~all( ok_ )
    warning( 'GenerateMFile:IgnoringNansAndInfs',...
        'Ignoring NaNs and Infs in data.' );
end
st_ = [2.8450000000000002 -1.139 4.694 ];
set(fo_,'Startpoint',st_);
ft_ = fittype('Bottom+(Top-Bottom)/(1+10^(LogEC50-x))',...
    'dependent',{'y'},'independent',{'x'},...
    'coefficients',{'Bottom', 'LogEC50', 'Top'});

% Fit this model using new data
cf_ = fit(IPTG_range_log10(ok_),LacZ_output_log10(ok_),ft_,fo_);
% Alternatively uncomment the following lines to use coefficients from the
% original fit. You can use this choice to plot the original fit against new
% data.
%    cv_ = { 2.8454697811995153, -1.1384771804932594, 4.6938375825440088};
%    cf_ = cfit(ft_,cv_{:});

% Plot this fit
h_ = plot(cf_,'fit',0.95);
set(h_(1),'Color',[1 0 0],...
    'LineStyle','-', 'LineWidth',2,...
    'Marker','none', 'MarkerSize',6);
% Turn off legend created by plot method.
legend off;
% Store line handle and fit name for legend.
legh_(end+1) = h_(1);
legt_{end+1} = 'fit 5';

% --- Create fit "fit 5 copy 1"
fo_ = fitoptions('method','NonlinearLeastSquares','Lower',[2 -2  4],'Upper',[3 -1  5]);
ok_ = isfinite(IPTG_range_log10) & isfinite(LacZ_output_log10);
if ~all( ok_ )
    warning( 'GenerateMFile:IgnoringNansAndInfs',...
        'Ignoring NaNs and Infs in data.' );
end
st_ = [2.8450000000000002 -1.139 4.694 ];
set(fo_,'Startpoint',st_);
ft_ = fittype('Bottom+(Top-Bottom)/(1+10^(LogEC50-x))',...
    'dependent',{'y'},'independent',{'x'},...
    'coefficients',{'Bottom', 'LogEC50', 'Top'});

% Fit this model using new data
cf_ = fit(IPTG_range_log10(ok_),LacZ_output_log10(ok_),ft_,fo_);
% Alternatively uncomment the following lines to use coefficients from the
% original fit. You can use this choice to plot the original fit against new
% data.
%    cv_ = { 2.8454697811995153, -1.1384771804932594, 4.6938375825440088};
%    cf_ = cfit(ft_,cv_{:});

% Plot this fit
h_ = plot(cf_,'fit',0.95);
set(h_(1),'Color',[0 0 1],...
    'LineStyle','-', 'LineWidth',2,...
    'Marker','none', 'MarkerSize',6);
% Turn off legend created by plot method.
legend off;
% Store line handle and fit name for legend.
legh_(end+1) = h_(1);
legt_{end+1} = 'fit 5 copy 1';

% --- Finished fitting and plotting data. Clean up.
hold off;
% Display legend
leginfo_ = {'Orientation', 'vertical'};
h_ = legend(ax_,legh_,legt_,leginfo_{:});
set(h_,'Units','normalized');
t_ = get(h_,'Position');
t_(1:2) = [0.451066,0.128049];
set(h_,'Interpreter','none','Position',t_);
% Remove labels from x- and y-axes.
xlabel(ax_,'');
ylabel(ax_,'');
